---
title: Bind the Images API to your Worker · Changelog
description: >
  You can now interact with the Images API directly in your Worker with Image
  Bindings.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-02-21-images-bindings-in-workers/
  md: https://developers.cloudflare.com/changelog/2025-02-21-images-bindings-in-workers/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Bind the Images API to your Worker

Feb 24, 2025

[Cloudflare Images](https://developers.cloudflare.com/images/)

You can now [interact with the Images API](https://developers.cloudflare.com/images/transform-images/bindings/) directly in your Worker.

This allows more fine-grained control over transformation request flows and cache behavior. For example, you can resize, manipulate, and overlay images without requiring them to be accessible through a URL.

The Images binding can be configured in the Cloudflare dashboard for your Worker or in the `wrangler.toml` file in your project's directory:

* wrangler.jsonc

  ```jsonc
  {
    "images": {
      "binding": "IMAGES", // i.e. available in your Worker on env.IMAGES
    },
  }
  ```

* wrangler.toml

  ```toml
  [images]
  binding = "IMAGES"
  ```

Within your Worker code, you can interact with this binding by using `env.IMAGES`.

Here's how you can rotate, resize, and blur an image, then output the image as AVIF:

```ts
const info = await env.IMAGES.info(stream);
// stream contains a valid image, and width/height is available on the info object


const response = (
  await env.IMAGES.input(stream)
    .transform({ rotate: 90 })
    .transform({ width: 128 })
    .transform({ blur: 20 })
    .output({ format: "image/avif" })
).response();


return response;
```

For more information, refer to [Images Bindings](https://developers.cloudflare.com/images/transform-images/bindings/).
